/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMMethod;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbemcmd.xml.XMLNode;
import org.snia.wbemcmd.xml.XMLParse;
import org.w3c.dom.Node;

public class CimXmlParser {
    private static final String PLUGINS_PATH = "plugins";
    private static final String TRACE_MASKT = "XFRMCXPT";
    private static final String TRACE_MASKF = "XFRMCXPF";
    private static final String TRACE_MASKD = "XFRMCXPD";
    private HashSet classes = new HashSet();

    public Set discoverXml() throws HException {
        Trace.trace(TRACE_MASKT, "-> CimXmlParser.discoverXml");
        String xmlPluginsPath = BaseFileControl.getFilePath(PLUGINS_PATH) + "xml/";
        File directory = new File(xmlPluginsPath);
        String[] fileNames = directory.list();
        File[] files = directory.listFiles();
        if (files != null) {
            for (int ix = 0; ix < files.length; ++ix) {
                this.processXml(files[ix].getPath());
            }
        }
        Trace.trace(TRACE_MASKT, "<- CimXmlParser.discoverXml");
        return this.classes;
    }

    private void processXml(String fileName) throws HException {
        Trace.trace(TRACE_MASKF, "-> processXml(fileName=" + fileName + ")");
        try {
            if (fileName.endsWith(".xml")) {
                FileInputStream fis = new FileInputStream(fileName);
                XMLParse parser = new XMLParse((InputStream)fis);
                XMLNode node = parser.parse(fileName);
                this.processCimNode(node);
            }
        }
        catch (CIMException cimexc) {
            HException hexc = new HException(cimexc);
            String text = "Exception caught while processing CIM XML file [" + fileName + "]";
            hexc.add(text);
            Trace.trace(TRACE_MASKT, hexc);
            throw hexc;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKT, "Exception caught while processing XML file [" + fileName + "]");
            Trace.trace(TRACE_MASKT, exc);
        }
        Trace.trace(TRACE_MASKF, "<- processXml()");
    }

    private void processCimNode(XMLNode cimNode) throws CIMException {
        for (XMLNode child = cimNode.getChild(); child != null; child = child.getNext()) {
            if (child.getToken() != XMLNode.XML_ELEMENT_DECLARATION) continue;
            this.processDeclarationNode(child);
        }
    }

    private void processDeclarationNode(XMLNode declarationNode) throws CIMException {
        for (XMLNode child = declarationNode.getChild(); child != null; child = child.getNext()) {
            if (child.getToken() != XMLNode.XML_ELEMENT_DECLGROUP) continue;
            this.processDeclGroupNode(child);
        }
    }

    private void processDeclGroupNode(XMLNode declGroupNode) throws CIMException {
        for (XMLNode child = declGroupNode.getChild(); child != null; child = child.getNext()) {
            if (child.getToken() != XMLNode.XML_ELEMENT_VALUE_OBJECT) continue;
            this.processValueObjectNode(child);
        }
    }

    private void processValueObjectNode(XMLNode valueObjectNode) throws CIMException {
        for (XMLNode child = valueObjectNode.getChild(); child != null; child = child.getNext()) {
            if (child.getToken() != XMLNode.XML_ELEMENT_CLASS) continue;
            this.processClassNode(child);
        }
    }

    private void processClassNode(XMLNode classNode) throws CIMException {
        CIMClass cimClass = new CIMClass((Node)classNode);
        String cimClassName = cimClass.getName();
        Iterator iterator = cimClass.getAllMethods().iterator();
        while (iterator.hasNext()) {
            ((CIMMethod)iterator.next()).setOriginClass(cimClassName);
        }
        iterator = cimClass.getAllProperties().iterator();
        while (iterator.hasNext()) {
            ((CIMProperty)iterator.next()).setOriginClass(cimClassName);
        }
        Trace.trace(TRACE_MASKF, "Adding class: " + cimClass.getName() + " with value: " + cimClass.toString());
        this.classes.add(cimClass);
    }
}

